# Nested_ANOVA_Anagrus.R
# Nested ANOVA for total eggs, after Cronin and Strong (1996)

# Load necessary libraries
library(ggplot2)
library(lme4)
library(lmerTest)
library(multcomp)

# Read in data set
nestdata <- read.table(header=T,colClasses=c(rep("factor",3),"numeric"),text="
site isoline wasp eggs
1   1  1  37
1   1  2  41
1   1  3  46
1   1  4  44
1   1  5  43
1   1  6  41
1   1  7  38
1   1  8  37
1   2  1  37
1   2  2  28
1   2  3  34
1   2  4  37
1   2  5  35
1   2  6  39
1   2  7  36
1   2  8  29
1   3  1  35
1   3  2  37
1   3  3  40
1   3  4  39
1   3  5  37
1   3  6  44
1   3  7  35
1   3  8  38
1   4  1  28
1   4  2  36
1   4  3  31
1   4  4  27
1   4  5  36
1   4  6  33
1   4  7  31
1   4  8  35
1   5  1  34
1   5  2  35
1   5  3  30
1   5  4  39
1   5  5  42
1   5  6  39
1   5  7  38
1   5  8  32
1   6  1  30
1   6  2  32
1   6  3  35
1   6  4  35
1   6  5  32
1   6  6  31
1   6  7  34
1   6  8  30
1   7  1  30
1   7  2  36
1   7  3  37
1   7  4  30
1   7  5  41
1   7  6  35
1   7  7  34
1   7  8  37
1   8  1  25
1   8  2  31
1   8  3  24
1   8  4  26
1   8  5  30
1   8  6  31
1   8  7  25
1   8  8  24
1   9  1  34
1   9  2  35
1   9  3  29
1   9  4  34
1   9  5  34
1   9  6  40
1   9  7  37
1   9  8  37
1  10  1  38
1  10  2  30
1  10  3  33
1  10  4  32
1  10  5  33
1  10  6  34
1  10  7  35
1  10  8  41
1  11  1  36
1  11  2  33
1  11  3  36
1  11  4  34
1  11  5  37
1  11  6  41
1  11  7  37
1  11  8  31
1  12  1  35
1  12  2  36
1  12  3  35
1  12  4  37
1  12  5  40
1  12  6  34
1  12  7  29
1  12  8  42
1  13  1  33
1  13  2  39
1  13  3  33
1  13  4  37
1  13  5  28
1  13  6  35
1  13  7  34
1  13  8  38
1  14  1  35
1  14  2  33
1  14  3  25
1  14  4  29
1  14  5  29
1  14  6  35
1  14  7  33
1  14  8  29
2   1  1  26
2   1  2  39
2   1  3  36
2   1  4  27
2   1  5  25
2   1  6  31
2   1  7  30
2   1  8  25
2   2  1  42
2   2  2  46
2   2  3  46
2   2  4  42
2   2  5  43
2   2  6  36
2   2  7  36
2   2  8  41
2   3  1  38
2   3  2  36
2   3  3  35
2   3  4  31
2   3  5  36
2   3  6  32
2   3  7  29
2   3  8  34
2   4  1  28
2   4  2  36
2   4  3  33
2   4  4  32
2   4  5  27
2   4  6  31
2   4  7  30
2   4  8  32
2   5  1  30
2   5  2  35
2   5  3  32
2   5  4  31
2   5  5  36
2   5  6  34
2   5  7  29
2   5  8  36
2   6  1  28
2   6  2  34
2   6  3  34
2   6  4  35
2   6  5  32
2   6  6  31
2   6  7  24
2   6  8  31
2   7  1  35
2   7  2  34
2   7  3  44
2   7  4  34
2   7  5  35
2   7  6  36
2   7  7  32
2   7  8  30
2   8  1  37
2   8  2  32
2   8  3  33
2   8  4  39
2   8  5  30
2   8  6  31
2   8  7  32
2   8  8  34
2   9  1  41
2   9  2  41
2   9  3  43
2   9  4  36
2   9  5  43
2   9  6  42
2   9  7  42
2   9  8  37
2  10  1  34
2  10  2  30
2  10  3  35
2  10  4  27
2  10  5  30
2  10  6  22
2  10  7  31
2  10  8  31
2  11  1  34
2  11  2  36
2  11  3  38
2  11  4  36
2  11  5  34
2  11  6  33
2  11  7  35
2  11  8  29
2  12  1  28
2  12  2  29
2  12  3  27
2  12  4  36
2  12  5  33
2  12  6  32
2  12  7  34
2  12  8  32
2  13  1  40
2  13  2  39
2  13  3  39
2  13  4  34
2  13  5  32
2  13  6  42
2  13  7  36
2  13  8  39
2  14  1  38
2  14  2  42
2  14  3  37
2  14  4  37
2  14  5  34
2  14  6  33
2  14  7  43
2  14  8  34
3   1  1  30
3   1  2  35
3   1  3  36
3   1  4  37
3   1  5  29
3   1  6  27
3   1  7  39
3   1  8  38
3   2  1  30
3   2  2  37
3   2  3  30
3   2  4  31
3   2  5  27
3   2  6  31
3   2  7  36
3   2  8  40
3   3  1  27
3   3  2  33
3   3  3  31
3   3  4  32
3   3  5  34
3   3  6  31
3   3  7  31
3   3  8  31
3   4  1  26
3   4  2  27
3   4  3  37
3   4  4  30
3   4  5  29
3   4  6  35
3   4  7  34
3   4  8  31
3   5  1  36
3   5  2  32
3   5  3  34
3   5  4  37
3   5  5  32
3   5  6  34
3   5  7  33
3   5  8  32
3   6  1  33
3   6  2  40
3   6  3  34
3   6  4  38
3   6  5  36
3   6  6  35
3   6  7  41
3   6  8  34
3   7  1  31
3   7  2  33
3   7  3  31
3   7  4  34
3   7  5  29
3   7  6  33
3   7  7  28
3   7  8  33
3   8  1  22
3   8  2  25
3   8  3  29
3   8  4  24
3   8  5  24
3   8  6  26
3   8  7  25
3   8  8  21
3   9  1  32
3   9  2  31
3   9  3  28
3   9  4  28
3   9  5  35
3   9  6  34
3   9  7  33
3   9  8  31
3  10  1  31
3  10  2  32
3  10  3  29
3  10  4  30
3  10  5  28
3  10  6  31
3  10  7  28
3  10  8  36
3  11  1  32
3  11  2  31
3  11  3  34
3  11  4  35
3  11  5  35
3  11  6  31
3  11  7  41
3  11  8  34
3  12  1  28
3  12  2  27
3  12  3  27
3  12  4  27
3  12  5  27
3  12  6  30
3  12  7  28
3  12  8  28
3  13  1  36
3  13  2  39
3  13  3  36
3  13  4  30
3  13  5  37
3  13  6  32
3  13  7  38
3  13  8  39
3  14  1  32
3  14  2  34
3  14  3  41
3  14  4  33
3  14  5  35
3  14  6  35
3  14  7  34
3  14  8  31
")

# Apply transformations here
nestdata <- transform(nestdata,y=eggs)

# Print data set
nestdata

# Graphics using ggplot2
ggplot(nestdata,aes(site,y))+
geom_jitter(size=2,position=position_jitter(width=0.1),color=nestdata$isoline)+
stat_summary(fun.data="mean_cl_normal",geom="errorbar",width=0.2,size=1)

# Mixed model
lmerout <- lmer(y~site+(1|site:isoline),data=nestdata,na.action=na.omit)
summary(lmerout)
anova(lmerout,type="II")

# All pairwise comparisons - Tukey method
compout <- glht(lmerout,linfct=mcp(site="Tukey"))
summary(compout)
confint(compout)
cld(compout)

# Diagnostic plots to check ANOVA assumptions
p <- fitted(lmerout)
r <- resid(lmerout)
plot(p,r)
qqnorm(r)

